/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { registerBlockType } from '@wordpress/blocks';

/**
 * Internal dependencies
 */
import './editor.scss';
import Block from './block';
import { deprecatedConvertToShortcode } from '../../utils/deprecations';
import { IconWidgets } from '../../components/icons';

registerBlockType( 'woofood/tabs-handpicked', {
	title: __( 'WooFood Tabs HandPicked', 'woofood' ),
	icon: {
		src: <IconWidgets />,
		foreground: '#96588a',
	},
	category: 'woofood',
	keywords: [ __( 'WooCommerce', 'woo-gutenberg-products-block' ) ],
	description: __(
		'Display a selection of hand-picked products in a grid.',
		'woo-gutenberg-products-block'
	),
	supports: {
		align: [ 'wide', 'full' ],
	},
	attributes: {
			editMode: false,


 BackgroundColor: {
 	type:'string',
 	default: ''
 },
    titleTextColor: {
 	type:'string',
 	default: ''
 },
    borderColor: {
 	type:'string',
 	default: ''
 },
		tabs: {
			type: 'array',
			default: [
			{
		 

		 align: '',

		/**
		 * Number of columns.
		 */

		/**
		 * Toggle for edit mode in the block preview.
		 */
		editMode: true,

		 		order: 'ASC',

		orderby: 'date',
				products: [],
						title:'Type A Namesss',
						BackgroundColor: '',
    titleTextColor: '',
    borderColor: '',
    icon: '',


		/**
		 * Content visibility setting
		 */
		contentVisibility: {
				title: true,
				price: true,
				rating: true,
				button: true,
			},

		/**
		 * How to order the products: 'date', 'popularity', 'price_asc', 'price_desc' 'rating', 'title'.
		 */

		/**
		 * The list of product IDs to display
		 */
    
			}





			],
		},
		/**
		 * Alignment of product grid
		 */
		


	},

	/*deprecated: [
		{
			// Deprecate shortcode save method in favor of dynamic rendering.
			attributes: {
				align: {
					type: 'string',
				},
				columns: {
					type: 'number',
					default: wc_product_block_data.default_columns,
				},
				editMode: true,
				contentVisibility: {
					type: 'object',
					default: {
						title: true,
						price: true,
						rating: true,
						button: true,
					},
				},
				orderby: {
					type: 'string',
					default: 'date',
				},
				products: {
					type: 'array',
					default: [],
				},

				title:
		{
      type: 'string',
      default: 'Type a Name',
    },
    BackgroundColor: {
      type: 'string',
      default: '',
    },
    titleTextColor: {
      type: 'string',
      default: '',
    },
    borderColor: {
      type: 'string',
      default: '',
    },
    icon: {
      type: 'string',
      default: '',
    }
			},
			save: deprecatedConvertToShortcode( 'woofood/accordion-handpicked' ),
		},
	],*/

	/**
	 * Renders and manages the block.
	 */
	edit( props ) {
		return <Block { ...props } />;
	},

	save() {
		return null;
	},
} );
