/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { SelectControl } from '@wordpress/components';
import PropTypes from 'prop-types';

/**
 * A pre-configured SelectControl for product orderby settings.
 */
const ProductOrderbyControl = ( { value, setAttributes } ) => {
	return (
		<SelectControl
			label={ __( 'Order products by', 'woofood' ) }
			value={ value }
			options={ [
				{
					label: __( 'Newness - newest first', 'woofood' ),
					value: 'date',
				},
				{
					label: __( 'Price - low to high', 'woofood' ),
					value: 'price_asc',
				},
				{
					label: __( 'Price - high to low', 'woofood' ),
					value: 'price_desc',
				},
				{
					label: __( 'Rating - highest first', 'woofood' ),
					value: 'rating',
				},
				{
					label: __( 'Sales - most first', 'woofood' ),
					value: 'popularity',
				},
				{
					label: __( 'Title - alphabetical', 'woofood' ),
					value: 'title',
				},
				{
					label: __( 'Menu Order', 'woofood' ),
					value: 'menu_order',
				},
			] }
			onChange={ ( orderby ) => setAttributes( { orderby } ) }
		/>
	);
};

ProductOrderbyControl.propTypes = {
	/**
	 * Callback to update the order setting.
	 */
	setAttributes: PropTypes.func.isRequired,
	/**
	 * The selected order setting.
	 */
	value: PropTypes.string.isRequired,
};

export default ProductOrderbyControl;
