<?php
defined('ABSPATH') or die;
/**
 * Page template with raw html
 */

global $post;
$data_provider = np_data_provider($post->ID);
$headerNp = $data_provider->getNpHeader();
$footerNp = $data_provider->getNpFooter();
$tmpPath = get_template_directory();
$cookiesSection = '';
$cookiesConsent = NpMeta::get('cookiesConsent') ? json_decode(NpMeta::get('cookiesConsent'), true) : '';
if ($cookiesConsent && (!$cookiesConsent['hideCookies'] || $cookiesConsent['hideCookies'] === 'false')) {
    $cookiesSection = $cookiesConsent['publishCookiesSection'];
}

$hideBackToTop = $data_provider->getHideBackToTop();
$backToTop = !$hideBackToTop ? NpMeta::get('backToTop') : '';
?>
<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php wp_head(); ?>
</head>
<body class="<?php echo $data_provider->getPageBodyClass(); ?>"
      style="<?php echo $data_provider->getPageBodyStyle(); ?>">
<?php $headerItem = '';
if ($headerNp && !$data_provider->getHideHeader()) {
    $headerItem = json_decode($headerNp, true);
    $publishHeader = $headerItem['php'];
    $publishHeader = Mediaspot_zopyron::processFormCustomPhp($publishHeader, 'header');
    $publishHeader = Mediaspot_zopyron::processContent($publishHeader, true, 'header');
}
if ($headerItem) {
    echo $headerItem['styles'];
    echo $publishHeader;
}
the_post();
the_content();
$footerItem = '';
if ($footerNp && !$data_provider->getHideFooter()) {
    $footerItem = json_decode($footerNp, true);
    $publishFooter = $footerItem['php'];
    $publishFooter = Mediaspot_zopyron::processFormCustomPhp($publishFooter, 'footer');
    $publishFooter = Mediaspot_zopyron::processContent($publishFooter, true, 'footer');
}
if ($footerItem) {
    echo $footerItem['styles'];
    echo $publishFooter;
}
wp_footer(); ?>
<?php echo $cookiesSection; ?>
<?php echo $backToTop; ?>
</body>
</html>